gl.setup(NATIVE_WIDTH, NATIVE_HEIGHT)

-- Default configuration
local cfg = { media_url = "", media_type = "video", fit = "cover", bg = "0,0,0" }
local vid, img

local function parse_rgb(s)
    local r,g,b = s:match("([^,]+),([^,]+),([^,]+)")
    r,g,b = tonumber(r) or 0, tonumber(g) or 0, tonumber(b) or 0
    return r, g, b
end

local function clear_media()
    if vid then vid:dispose() vid = nil end
    if img then img:dispose() img = nil end
end

local function load_media()
    clear_media()
    if cfg.media_type == "video" and cfg.media_url ~= "" then
        -- Plays MP4/H.264 over HTTP(S). HLS/RTSP depending on OS support.
        vid = resource.load_video{
            file = cfg.media_url, looped = true, audio = false, raw = true
        }
    elseif cfg.media_type == "image" and cfg.media_url ~= "" then
        img = resource.load_image(cfg.media_url)
    end
end

-- Watch dashboard-provided configuration
util.json_watch("config.json", function(new_cfg)
    cfg = new_cfg
    load_media()
end)

local function place(w, h)
    local x1, y1, x2, y2 = 0, 0, WIDTH, HEIGHT
    if cfg.fit == "contain" and w > 0 and h > 0 then
        local scale = math.min(WIDTH / w, HEIGHT / h)
        local nw, nh = w*scale, h*scale
        x1 = (WIDTH - nw)/2; y1 = (HEIGHT - nh)/2
        x2 = x1 + nw; y2 = y1 + nh
        return x1,y1,x2,y2
    elseif cfg.fit == "cover" and w > 0 and h > 0 then
        local scale = math.max(WIDTH / w, HEIGHT / h)
        local nw, nh = w*scale, h*scale
        x1 = (WIDTH - nw)/2; y1 = (HEIGHT - nh)/2
        x2 = x1 + nw; y2 = y1 + nh
        return x1,y1,x2,y2
    else
        return 0,0,WIDTH,HEIGHT   -- stretch
    end
end

function node.render()
    local r,g,b = parse_rgb(cfg.bg or "0,0,0")
    gl.clear(r,g,b,1)

    if vid and vid:state() == "loaded" then
        local w,h = vid:width(), vid:height()
        vid:place(place(w,h))
    elseif img then
        local w,h = img:width(), img:height()
        img:draw(place(w,h))
    else
        -- Nothing configured yet; just display background color.
        -- Configure this node in the dashboard: set Media URL and Type.
    end
end
